<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class MooseInstagramWidget extends WP_Widget {
	protected $params;
	
	public function __construct() {
		parent::__construct(
			'eltd_instagram_widget',
			esc_html__( 'Moose Instagram Widget', 'moose-instagram-feed' ),
			array(
				'description' => esc_html__( 'Display your Instagram feed', 'moose-instagram-feed' )
			)
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'name'  => 'title',
				'type'  => 'textfield',
				'title' => esc_html__( 'Title', 'moose-instagram-feed' )
			),
			array(
				'name'  => 'number_of_photos',
				'type'  => 'textfield',
				'title' => esc_html__( 'Number of Photos', 'moose-instagram-feed' )
			),
			array(
				'name'    => 'number_of_cols',
				'type'    => 'dropdown',
				'title'   => esc_html__( 'Number of Columns', 'moose-instagram-feed' ),
				'options' => array(
					'2' => esc_html__( 'Two', 'moose-instagram-feed' ),
					'3' => esc_html__( 'Three', 'moose-instagram-feed' ),
					'4' => esc_html__( 'Four', 'moose-instagram-feed' ),
					'6' => esc_html__( 'Six', 'moose-instagram-feed' ),
					'9' => esc_html__( 'Nine', 'moose-instagram-feed' )
				)
			),
			array(
				'name'    => 'image_size',
				'type'    => 'dropdown',
				'title'   => esc_html__( 'Image Size', 'moose-instagram-feed' ),
				'options' => array(
					'thumbnail'           => esc_html__( 'Small', 'moose-instagram-feed' ),
					'low_resolution'      => esc_html__( 'Medium', 'moose-instagram-feed' ),
					'standard_resolution' => esc_html__( 'Large', 'moose-instagram-feed' )
				)
			),
			array(
				'name'  => 'transient_time',
				'type'  => 'textfield',
				'title' => esc_html__( 'Images Cache Time', 'moose-instagram-feed' )
			)
		);
	}
	
	public function getParams() {
		return $this->params;
	}
	
	public function widget( $args, $instance ) {
		extract( $instance );

		echo wp_kses_post($args['before_widget']);
		if ( ! empty( $title ) ) {
			echo wp_kses_post($args['before_title']) . wp_kses_post($title ). wp_kses_post($args['after_title']);
		}
		
		$instagram_api = MooseInstagramApi::getInstance();
		$images_array = $instagram_api->getImages($number_of_photos, array(
			'use_transients' => true,
			'transient_name' => $args['widget_id'],
			'transient_time' => $transient_time
		));
		
		$number_of_cols = $number_of_cols == '' ? 3 : $number_of_cols;
		
		if ( is_array( $images_array ) && count( $images_array ) ) { ?>
			<ul class="eltd_instagram_feed clearfix col_<?php echo esc_attr($number_of_cols); ?>">
				<?php
				foreach ( $images_array as $image ) { ?>
					<li>
						<a href="<?php echo esc_url($instagram_api->getHelper()->getImageLink($image)); ?>" target="_blank">
							<?php echo moose_elated_kses_img($instagram_api->getHelper()->getImageHTML($image, $image_size)); ?>
						</a>
					</li>
				<?php } ?>
			</ul>
		<?php }

		echo wp_kses_post($args['after_widget']);
	}
	
	public function form( $instance ) {
		foreach ( $this->params as $param_array ) {
			$param_name    = $param_array['name'];
			${$param_name} = isset( $instance[ $param_name ] ) ? esc_attr( $instance[ $param_name ] ) : '';
		}
		
		$instagram_api = MooseInstagramApi::getInstance();
		
		//user has connected with instagram. Show form
		if ( $instagram_api->hasUserConnected() ) {
			foreach ( $this->params as $param ) {
				switch ( $param['type'] ) {
					case 'textfield':
						?>
						<p>
							<label for="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>"><?php echo esc_html( $param['title'] ); ?></label>
							<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( $param['name'] ) ); ?>" type="text" value="<?php echo esc_attr( ${$param['name']} ); ?>"/>
						</p>
						<?php
						break;
					case 'dropdown':
						?>
						<p>
							<label for="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>"><?php echo esc_html( $param['title'] ); ?></label>
							<?php if ( isset( $param['options'] ) && is_array( $param['options'] ) && count( $param['options'] ) ) { ?>
								<select class="widefat" name="<?php echo esc_attr( $this->get_field_name( $param['name'] ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( $param['name'] ) ); ?>">
									<?php foreach ( $param['options'] as $param_option_key => $param_option_val ) {
										$option_selected = '';
										if ( ${$param['name']} == $param_option_key ) {
											$option_selected = 'selected';
										}
										?>
										<option <?php echo esc_attr( $option_selected ); ?> value="<?php echo esc_attr( $param_option_key ); ?>"><?php echo esc_attr( $param_option_val ); ?></option>
									<?php } ?>
								</select>
							<?php } ?>
						</p>
						
						<?php
						break;
				}
			}
		}
	}
}

if ( ! function_exists( 'moose_instagram_feed_widget_load' ) ) {
	function moose_instagram_feed_widget_load() {
		if ( moose_instagram_theme_installed() ) {
			register_widget( 'MooseInstagramWidget' );
		}
	}
	
	add_action( 'widgets_init', 'moose_instagram_feed_widget_load' );
}